/**
 * \file: grl_dlt_log.c
 *
 * \version: $Id: grl_dlt_log.c,v 0.1 2015/05/20 11:53:54 $
 *
 * \component:   Dlt support for svg component
 *
 * \author:Anil.V
 *
 * \copyright: (c) 2003 - 2004 ADIT Corporation
 *
 * \history
 *
 ***********************************************************************/

#include "grl_dlt_log.h"
#include "grl_os_abstraction.h"
#include "dlt.h"
#include "adit_dlt.h"

#define MAX_BUFFER_SIZE		 1024		/*Maximum size of a string can be passed*/

typedef va_list								arg_list;
#define SVGARG_START(argument, pointer)		va_start(argument, pointer)
#define SVGARG_END(argument)				va_end(argument)

SVGUint8 grl_scom_debugLevel = SVG_LOG_FATAL;
void *grl_scom_dlt_ctx = NULL;

SVGUint8 _isDLTInitialized = SVG_FALSE;


/************************** DLT Function declaration *****************************/

void svg_print_ctx(void * comp_ctx, SVGUint8 level, SVGChar* msg, va_list args);

SVGInt32 scomDltLogLevelInjection(SVGUint32 service_id, void * data, SVGUint32 length);

void scom_dlt_SetDebugLevel(SVGUint8 Level );

void scom_dlt_GetDebugLevel( SVGUint8 *DebugLevel );

/**
 * \func svg_init_dlt
 *
 * Initializing DLT for svg component
 *
 */
/*
void *svg_init_dlt( SVGChar *name, SVGChar *dscip ,SVGUint32 serviceID,
		SVGInt32 (*svgDltLogLevelInjection)
				(SVGUint32 service_id, void * data, SVGUint32 length) )
*/
void *svg_init_dlt( SVGChar *name, SVGChar *dscip ,SVGUint32 serviceID,
		svgDltLogLevelInjection fnptr_svg_dltinjection)
{
	const SVGChar* InitMessage = "DLT initialized for SVG Component";
	/* DLT_ID_SIZE is required to copy APPID from DLT */
	SVGChar AppId[DLT_ID_SIZE+1] = {0};

	DltContext *handle = (DltContext *)GRL_malloc_1D_resource(sizeof( DltContext));

	if( NULL != handle )
	{
		DLT_GET_APPID(AppId);
		if (AppId[0] == '\0') {
			DLT_REGISTER_APP(DLT_SVG_COMP_APID, "SVG Application");
		}


		DLT_REGISTER_CONTEXT( *handle, name, dscip);

		DLT_REGISTER_INJECTION_CALLBACK(*handle,
				serviceID,
				fnptr_svg_dltinjection);

		DLT_LOG(*handle,DLT_LOG_INFO,DLT_STRING(InitMessage),DLT_STRING(name) );
	}
	return (void *) handle;
}

void svg_print_ctx(void * comp_ctx, SVGUint8 level, SVGChar* msg, va_list args)
{

	SVGChar buffer[MAX_BUFFER_SIZE]={0};
	SVGUint16 len;

	/* Format the string. */
	len = vsnprintf(buffer, sizeof(buffer), msg, args);
	if (MAX_BUFFER_SIZE > (len+2))
	{
		buffer[len] = '\0';
		buffer[len++] = '\n';
	}
	switch (level) {
	case SVG_LOG_FATAL:
		 DLT_LOG(*(DltContext*)comp_ctx, DLT_LOG_FATAL, DLT_STRING(buffer));
		 break;
	case SVG_LOG_ERROR:
		 DLT_LOG(*(DltContext*)comp_ctx, DLT_LOG_ERROR, DLT_STRING(buffer));
		 break;
	case SVG_LOG_WARN:
		 DLT_LOG(*(DltContext*)comp_ctx, DLT_LOG_WARN, DLT_STRING(buffer));
		 break;
	case SVG_LOG_INFO:
		 DLT_LOG(*(DltContext*)comp_ctx, DLT_LOG_INFO, DLT_STRING(buffer));
		 break;
	case SVG_LOG_DEBUG:
		 DLT_LOG(*(DltContext*)comp_ctx, DLT_LOG_DEBUG, DLT_STRING(buffer));
		 break;

	default:
		 DLT_LOG(*(DltContext*)comp_ctx, DLT_LOG_VERBOSE, DLT_STRING(buffer));
		 break;
	}
}

/**
 * \func svg_print
 *
 * Input:
 * comp : ctx name
 * level: level of the message
 * msg  : Message
 *
 *Output:
 *		Nothing
 */
void svg_print(void * ctx ,SVGUint8 debug_level ,SVGUint8 level, SVGChar* msg,...)
{

	if( NULL!=ctx )
	{
		arg_list args;

		if( level > debug_level )
		{
			/* do nothing */
		}
		else
		{
/* PRQA: Lint Message 530: False positive, the va_start is initializing args */
/*lint -save -e530 */
			SVGARG_START(args, msg);
			svg_print_ctx(ctx, level, msg, args);
			SVGARG_END(args);
/*lint -restore*/
		}
	}
}


/**
 * \func svg_print_com
 *
 * Input:
 * comp : ctx name
 * level: level of the message
 * msg  : Message
 *
 *Output:
 *		Nothing
 */
void svg_print_com(void * ctx ,SVGUint8 debug_level ,SVGUint8 level, SVGChar* msg,...)
{

	arg_list args;

	/* Atomic operation test and set*/
	/* DLT registration should be done only once */
	if(SVG_FALSE == _isDLTInitialized)
	{
		grl_scom_dlt_ctx = svg_init_dlt("SCOM", "DLT CONTEXT CREATED FOR SVG COMMON",
					DLT_SERVICE_LOGLVL_SCOM,
					scomDltLogLevelInjection );
		ctx = grl_scom_dlt_ctx;
		_isDLTInitialized = SVG_TRUE;
	}

	if( NULL!=ctx )
	{
		if( level > debug_level )
		{
			/* do nothing */
		}
		else
		{
/* PRQA: Lint Message 530: False positive, the va_start is initializing args */
/*lint -save -e530 */
			SVGARG_START(args, msg);

			svg_print_ctx(ctx, level, msg, args);

			SVGARG_END(args);
/*lint -restore*/
		}
	}
}


SVGInt32 scomDltLogLevelInjection(SVGUint32 service_id, void * data,
					SVGUint32 length )
{
	SVGUint32 i = 0;
	SVGChar* buf = (SVGChar *)data;
	SVGUint8 newDebugLevel = SVG_LOG_FATAL;

	UNUSED_ARG(length);

	scom_dlt_GetDebugLevel(&newDebugLevel);

	for (i = 0 ; buf[i]; i++)
		buf[i] = tolower(buf[i]);

	if (strncmp("fatal", buf, 5) == 0)
		newDebugLevel = SVG_LOG_FATAL;
	else if (strncmp("error", buf, 5) == 0)
		newDebugLevel = SVG_LOG_ERROR;
	else if (strncmp("warning", buf, 7) == 0)
		newDebugLevel = SVG_LOG_WARN;
	else if (strncmp("info", buf, 4) == 0)
		newDebugLevel = SVG_LOG_INFO;
	else if (strncmp("debug", buf, 5) == 0)
		newDebugLevel = SVG_LOG_DEBUG;
	else if (strncmp("verbose", buf, 7) == 0)
		newDebugLevel = SVG_LOG_VERBOSE;

	scom_dlt_SetDebugLevel(newDebugLevel);

	SVG_COM_U("Log level set to %u for service ID %x ", newDebugLevel,service_id);

	return 0;
}


/*******************************************************************************
**  scom_dlt_SetDebugLevel
**  Set the debug level.
**
**  INPUT:
**      SVGUint32 Level
**          New debug level.
**  OUTPUT:
**      Nothing.
*/

void scom_dlt_SetDebugLevel(SVGUint8 Level )
{
	grl_scom_debugLevel = Level;
}

/*******************************************************************************
**  scom_dlt_GetDebugLevel
**  Get the current debug level.
**
**  INPUT:
**      Nothing.
**  OUTPUT:
**      SVGUint32 DebugLevel
**          Handle to store the debug level.
*/
void scom_dlt_GetDebugLevel( SVGUint8 *DebugLevel  )
{
    *DebugLevel = grl_scom_debugLevel;
}


/*******************************************************************************
**  svg_de_init_dlt
**  Get the unregister and free the DLT context.
**
**  INPUT:
**      Dlt context
**  OUTPUT:
**  	Nothing
*/
void svg_de_init_dlt( void * ctx )
{
	/* Unregister CONTEXTS... */
	if( NULL !=ctx )
	{
		DLT_UNREGISTER_CONTEXT(*(DltContext*)ctx);
		GRL_free_1D_resource(ctx);
	}
}
